function guiWithEditbox
% guiWithEditbox has an editable text box
%  and a callback function that prints the user's
%  text in red 
% Format: guiWithEditbox or guiWithEditbox()
 
% Create the GUI but make it invisible for now 
f = figure('Visible', 'off','color','white','Units',...
    'Normalized','Position', [.25 .5 .4 .2]);
% Put a name on it and move it to the center of the screen
f.Name = 'GUI with editable text';
movegui(f,'center')
% Create two objects: a box where the user can type and 
%  edit a text and also a text title for the edit box
hsttext = uicontrol('Style','text',...
    'BackgroundColor','white','Units','Normalized',...
    'Position',[.2 .6 .6 .2],...
    'String','Enter your text here');
huitext = uicontrol('Style','edit', 'Units',...
    'Normalized','Position',[.3 .3 .4 .2], ...
    'Callback',@callbackfn);
 
% Now the GUI is made visible
f.Visible = 'on';
 
    % Call back function
    function callbackfn(hObject,eventdata)
        % callbackfn is called by the 'Callback' property
        % in the editable text box
        set([hsttext huitext],'Visible','off');
        % Get the text that the user entered and print 
        %   it in big red letters
        printstr = huitext.String;
        hstr = uicontrol('Style','text',...
            'BackgroundColor','white','Units',...
            'Normalized','Position',[.1 .3 .8 .4],...
		    'String',printstr,...
            'ForegroundColor','Red','FontSize',30);
        hstr.Visible = 'on';
    end
end
